function difference = GMM_res_competitive(x, y, moments, W, N_variables, N_ll)
% This function computes the output to be minimized in the GMM procedure
%
% Input:
%   x = parameters to be estimated 
%   y = calibrated parameters     
%   data_moments = 16x1 data moments
%   W = weightning matrix
% 
% Output:
%   output = M' * W * M

if nargin<4
    W = eye(length(moments));
end


% Moving estimated parameters into bounds
x(1) = exp(x(1))/(1+exp(x(1)));                       % epsilon
lambda(1:2) = (1 - 2 * exp(x(2:3))./(1+exp(x(2:3)))); % rhos eigenvalues
x(2) = lambda(1) + lambda(2);                         % rho_a1
x(3) = - lambda(1) * lambda(2);                       % rho_a2
x(4:5) = 10^(-7) + exp(x(4:5));                       % var_u var_a
x(4:5) = min(x(4:5), 5);

parameters = [y,x];

try
    model_moments = Model_Moments_competitive(parameters, N_variables, N_ll);
    M = (moments - model_moments)';
    difference = M' * W * M;
    disp(['Current Difference = ' num2str(difference)])
catch e
    difference = nan;
    disp(['Dynare error in parameterization'])
    disp(e.message);
end